﻿document.addEventListener('DOMContentLoaded', function () {
    const keywordInput = document.getElementById('keywordInput');
    const isRegexCheckbox = document.getElementById('isRegex');
    const addButton = document.getElementById('addKeyword');
    const keywordList = document.getElementById('keywordList');

    // 加载保存的关键词和屏蔽作者
    loadKeywords();
    loadBlockedAuthors(); // 确保这行被调用

    addButton.addEventListener('click', addKeyword);

    function addKeyword() {
        const keyword = keywordInput.value.trim();
        const isRegex = isRegexCheckbox.checked;

        if (!keyword) return;

        chrome.storage.local.get(['keywords'], function (result) {
            const keywords = result.keywords || [];
            keywords.push({ keyword, isRegex, id: Date.now() });

            chrome.storage.local.set({ keywords }, function () {
                keywordInput.value = '';
                loadKeywords();
            });
        });
    }

    function loadKeywords() {
        chrome.storage.local.get(['keywords'], function (result) {
            const keywords = result.keywords || [];
            keywordList.innerHTML = '';

            keywords.forEach(item => {
                const keywordItem = document.createElement('div');
                keywordItem.className = 'keyword-item';
                keywordItem.innerHTML = `
                    <span>${item.keyword} ${item.isRegex ? '(正则)' : ''}</span>
                    <button data-id="${item.id}">删除</button>
                `;
                keywordList.appendChild(keywordItem);
            });

            // 添加删除事件监听
            keywordList.querySelectorAll('button').forEach(button => {
                button.addEventListener('click', function () {
                    const id = parseInt(this.getAttribute('data-id'));
                    deleteKeyword(id);
                });
            });
        });
    }

    function deleteKeyword(id) {
        chrome.storage.local.get(['keywords'], function (result) {
            const keywords = result.keywords.filter(item => item.id !== id);
            chrome.storage.local.set({ keywords }, loadKeywords);
        });
    }

    // 加载屏蔽作者列表
    function loadBlockedAuthors() {
        chrome.storage.local.get(['blockedAuthors'], function (result) {
            const authors = result.blockedAuthors || [];
            const authorList = document.getElementById('authorList');

            if (authorList) {
                authorList.innerHTML = '';

                if (authors.length === 0) {
                    authorList.innerHTML = '<div style="color: #666; text-align: center;">暂无屏蔽的作者</div>';
                    return;
                }

                authors.forEach(author => {
                    const authorItem = document.createElement('div');
                    authorItem.className = 'author-item';
                    authorItem.style.cssText = `
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                        padding: 8px;
                        margin: 4px 0;
                        background: #f5f5f5;
                        border-radius: 4px;
                    `;

                    authorItem.innerHTML = `
                        <span style="flex: 1;">${author}</span>
                        <button class="unblock-btn" data-author="${author}">取消屏蔽</button>
                    `;

                    authorList.appendChild(authorItem);
                });

                // 添加取消屏蔽事件监听
                authorList.querySelectorAll('.unblock-btn').forEach(btn => {
                    btn.addEventListener('click', function () {
                        const author = this.getAttribute('data-author');
                        unblockAuthor(author);
                    });
                });
            }
        });
    }

    function unblockAuthor(authorName) {
        chrome.storage.local.get(['blockedAuthors'], function (result) {
            let authors = result.blockedAuthors || [];
            authors = authors.filter(a => a !== authorName);

            chrome.storage.local.set({ blockedAuthors: authors }, function () {
                loadBlockedAuthors();
                // 通知内容脚本更新
                chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
                    if (tabs[0]) {
                        chrome.tabs.sendMessage(tabs[0].id, {
                            action: 'updateBlockedAuthors',
                            authors: authors
                        });
                    }
                });
            });
        });
    }

    // 添加存储变化监听，实时更新列表
    chrome.storage.onChanged.addListener(function (changes, namespace) {
        if (changes.blockedAuthors) {
            loadBlockedAuthors();
        }
        if (changes.keywords) {
            loadKeywords();
        }
    });
});